$Title: GTAP Land-Water Use by AEZ River Basin for 2011

$ontext
Haqiqi I., F. Taheripour, J. Liu, and D. van der Mensbrugghe.
"Introducing Irrigation Water into GTAP Database Version 9"
Journal of Global Economic Analysis
December, 2016.

Contact: ihaqiqi@purdue.edu
https://www.gtap.agecon.purdue.edu/resources/res_display.asp?RecordID=5168


Includes:
  (1) Split GTAP Land Use to River Basins
  (2) Split GTAP Land Use to Irrigated-Rinfed
  (3) Estimate Water Use for 2011

$offtext

*--------------------------------------------------*
*Introduction
*--------------------------------------------------*
*     Land use data by AEZ for 2011 is privided by Pea-Lvano et al. (2015).
*     Land use data by river basin for 2000 is provided by PSD(2000).
*     Land use data for the missing regions is taken from FAOSTAT.



*Name the sets to be imported
*--------------------------------------------------*
sets
  B        set of 126 river basins,
  A        set of 18 agro ecological zones,
  GTC8     set of 8 GTAP crops,
  LTYP     set of land cover types,
  REG      set of 140 GTAP regions,
  lreg(reg) set of 134 GTAP land regions
  ;
alias
  (GTC8,CROP,C),
  (lreg,lr),
  (REG,R)
  (A,AEZ),
  (B,RB)


*    -------------------------
*     Read 2000 land use data
*    -------------------------
Parameters
  prod0     production by aez-rb in 2000 in PSD Database
  hvst0     harvested area by aez-rb in 2000 in PSD Database
  prod00    production by aez-rb in 2000 in PSD Database- by irrigation type
  area00    harvested area by aez-rb in 2000 in PSD Database- by irrigation type
  cover2000 land cover data
  hvstaez   harvested area by aez
  prodaez   production by aez
;

$Gdxin ../in/PSD2000_140reg126rb18aez8crop.gdx
$load reg, b,a, prod0, hvst0, prod00, area00, cover2000
$Gdxin

$Gdxin ../in/LandUsev4.gdx
$load hvstaez, prodaez
$Gdxin


*    -------------------------
*     Read 2011 land use data
*    -------------------------
parameters
  HVST11   Harvested Area in 2011 in GTAP-AEZ Land Use Database ,
  PROD11   Production in 2011 in GTAP-AEZ Land Use Database ,
  LCOV11   Land cover in 2011 in GTAP-AEZ Land Use Database ;

* Import from GDX file
$Gdxin ../in/Luis_2011_AEZ_8GTAPcrops_134Countries.gdx
$Load gtc8,lreg,hvst11,prod11,lcov11,ltyp
$Gdxin

hvst11(a,c,r)$(not sum(aez, hvst11(aez,c,r))) = hvstaez(r,a,c);
prod11(a,c,r)$(not sum(aez, prod11(aez,c,r))) = prodaez(r,a,c);
lcov11(a,ltyp,r)$(not lcov11(a,ltyp,r)) = eps;


*   -------------------------------------------
*        read blue water data from SD (2000)
*   -------------------------------------------
Parameter
  WatSD(reg,rb,aez,gtc8)  blue water requirement in Siebert database ;
$libinclude xlimport WatSD ../in/BlueWater2000_140reg126rb18aez.xlsx BlueWater2000!a1


*   ---------------------------
*        read FAO water data
*   ----------------------------
SETS
  YEAR
PARAMETERS
  AGWW(REG,YEAR)
  IRWW(REG,YEAR)
  IRWR(REG,YEAR)
$Gdxin ../in/FAOWaterWithdrawal.gdx
$Load YEAR, AGWW, IRWW, IRWR
$Gdxin


*   ---------------------------
*        Call splitting codes
*   ----------------------------
*  ch 1: Splitting GTAP Land Use by River Basin
$include SplitRB.gms

*  ch 2: Splitting GTAP Land Use to Irrigated Rain Fed
$include SplitIRG.gms

*  ch 3: Estimating water withdrawal for 2011 by RB-AEZ for 140 reg     *
$include WaterEst.gms


*   ---------------------------
*        report
*   ----------------------------
parameter INFO "<<GTAP-RB-AEZ Water Land Use Database for 2011 (Dec 2016)>>" /1/
execute_unload 'LandWaterUse_RB_AEZ.gdx'
  info
  hvst11, prod11, lcov11
  reg, crop, aez, rb, ltyp
  hvst, prdn, frst, pstr, clnd
  hi, hr, qi, qr
  wtr0, wtr11
*hvstaez, prodaez
*xhvst, xprdn, zhvst, zprdn, error
*hvst_miss, prod_miss, frst_miss, pstr_miss, h_miss, q_miss
execute "gdx2har LandWaterUse_RB_AEZ.gdx ../out/LandWaterUse_RB_AEZ.har";


*    =============================
*    END OF main.gms FILE
*    =============================
